
#ifndef _1_KMNG_ATP_TST_ManageOp_h_H
#define _1_KMNG_ATP_TST_ManageOp_h_H

/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */
#include "DX_VOS_BaseTypes.h"
#include "KMNG_ATP_TST_Defines.h"
#include "KMNG_Defs.h"


#ifdef __cplusplus
extern "C"
{
#endif


  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Tue Nov 30 10:18:14 2004
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_ATP_TST_AES_Acceptance.h#1:incl:1
   *  \author NogaD
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */


/************************ Defines *******************************/
/************************ Enums *********************************/
/************************ Typedefs  *****************************/
/************************ Structs  ******************************/
typedef struct TST_RingManage_TestDataStruct{	
	DxChar					    TST_Name[TST_NAME_STRING_LEN];
	DxUint8_t           TST_Pwd[TST_KMNG_PWD_MAX_LEN];
	DxUint32_t          TST_PwdLen;
	DxUint32_t          TST_NumSymKeys;
	DxUint32_t          TST_NumRSAKeys;
	DxUint32_t          TST_NumDHKeys;
} TST_RingManage_TestDataStruct;

typedef struct TST_RingListSym_TestDataStruct{	
  DxChar					          TST_Name[TST_NAME_STRING_LEN];
  DxUint8_t                 TST_KeyPwd[TST_KMNG_PWD_MAX_LEN];
  DxUint32_t                TST_KeyPwdLen;
  KMNG_KeyType_t            TST_KeyType;
  DxUint32_t                TST_KeyUsage;
  DxUint32_t                TST_KeyRestriction;
  DxUint8_t                 TST_key[TST_KMNG_SYM_KEY_MAX_SIZE];
  DxUint32_t                TST_KeySize;
  DxUint8_t                 TST_Exportedkey[TST_KMNG_SYM_KEY_MAX_SIZE];  
}TST_RingListSym_TestDataStruct;
 
typedef struct TST_RingListRSA_TestDataStruct{	 
  DxChar					          TST_Name[TST_NAME_STRING_LEN];
  DxUint8_t                 TST_KeyPwd[TST_KMNG_PWD_MAX_LEN];
  DxUint32_t                TST_KeyPwdLen;
  KMNG_KeyType_t            TST_KeyType;
  DxUint32_t                TST_KeyUsage;
  DxUint32_t                TST_KeyRestriction;
  DxUint32_t                TST_KeySize;
  DxUint8_t                 TST_E[TST_KMNG_PWD_MAX_LEN];
  DxUint32_t                TST_ESize;
  DxUint8_t                 TST_ExportedE[TST_KMNG_PWD_MAX_LEN];
  DxUint32_t                TST_ExportedESize;
  DxUint8_t                 TST_N[TST_KMNG_MAX_RSA_PARAM_SIZE];
  DxUint32_t                TST_NSize;
  DxUint8_t                 TST_ExportedN[TST_KMNG_MAX_RSA_PARAM_SIZE];
  DxUint32_t                TST_ExportedNSize;
  DxUint8_t                 TST_D[TST_KMNG_MAX_RSA_PARAM_SIZE];
  DxUint32_t                TST_DSize;
  DxUint8_t                 TST_ExportedD[TST_KMNG_MAX_RSA_PARAM_SIZE];
  DxUint32_t                TST_ExportedDSize;
}TST_RingListRSA_TestDataStruct;

typedef struct TST_RingListDH_TestDataStruct{	 
  DxChar					          TST_Name[TST_NAME_STRING_LEN];
  DxUint8_t                 TST_KeyPwd[TST_KMNG_PWD_MAX_LEN];
  DxUint32_t                TST_KeyPwdLen;
  KMNG_KeyType_t            TST_KeyType;
  DxUint32_t                TST_KeyUsage;
  DxUint32_t                TST_KeyRestriction;
  DxUint8_t                 TST_P[TST_KMNG_MAX_RSA_PARAM_SIZE];
  DxUint32_t                TST_PSize;
  DxUint8_t                 TST_ExportedP[TST_KMNG_MAX_RSA_PARAM_SIZE];
  DxUint32_t                TST_ExportedPSize;
  DxUint8_t                 TST_G[TST_KMNG_MAX_RSA_PARAM_SIZE];
  DxUint32_t                TST_GSize;
  DxUint8_t                 TST_ExportedG[TST_KMNG_MAX_RSA_PARAM_SIZE];
  DxUint32_t                TST_ExportedGSize;
  DxUint8_t                 TST_N[TST_KMNG_MAX_RSA_PARAM_SIZE];
  DxUint32_t                TST_NSize;
  DxUint8_t                 TST_ExportedN[TST_KMNG_MAX_RSA_PARAM_SIZE];
  DxUint32_t                TST_ExportedNSize;
  DxUint8_t                 TST_D[TST_KMNG_MAX_RSA_PARAM_SIZE];
  DxUint32_t                TST_DSize;
  DxUint8_t                 TST_ExportedD[TST_KMNG_MAX_RSA_PARAM_SIZE];
  DxUint32_t                TST_ExportedDSize;
}TST_RingListDH_TestDataStruct;
                              
/************************ Public Variables **********************/
/************************ Public Functions **********************/
/*****************************************************************************
 * Function Name:                                                           
 *  KMNG_ATP_TST_Key_Ring_Management      
 *  
 * Inputs:
 *  None
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is an acceptance test for Key management API's. The function 
 *  initializes a key ring according to requested num of keys
 *  
 * Algorithm:       
 * 1. Get key ring buffer size for X keys (symmetric, RSA and DH)
 * 2. Allocate a buffer for the key ring according to the needed size 
 * 3. Initialize a key ring
 * 4. Get key ring capacity and compare to expected size
 * 5. Get key ring current size (0 objects) and compare to expected size
 *
 *  * Implements KMNG ATP section 5.1 
 *
 ******************************************************************************/                                
DxError_t KMNG_ATP_TST_Key_Ring_Management( void );

/*****************************************************************************
 * Function Name:                                                           
 *  KMNG_ATP_TST_Key_Ring_List      
 *  
 * Inputs:
 *  None
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is an acceptance test for Key management API's. The function 
 *  tests the list key IDs function.
 *  
 * Algorithm:       
 * 1. Initialize a key ring according to requested number of keys
 * 2. Import Symmetric,RSA and DH keys
 * 3. Get the key ring current size, verify its correct and list all the key IDs
 *    Verify that the Key IDs are as expected
 * 4. Export all the imported keys, verify that the exported keys are as expected
 * 5. Delete a symmetric RSA and DH key (in a loop till all keys are deleted)
 * 6. List the keys after each deletion, verify that the remained keys are as 
 *    expected
 * 
 *  * Implements KMNG ATP section 5.3 
 *
 ******************************************************************************/                                
DxError_t KMNG_ATP_TST_Key_Ring_List( void );

/*****************************************************************************
 * Function Name:                                                           
 *  KMNG_ATP_TST_Operations_2_Key_Ring      
 *  
 * Inputs:
 *  None
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is an acceptance test for Key management API's. The function 
 *  tests the list key IDs function.
 *  
 * Algorithm:       
 * 1. Initialize 2 Key Rings (A & B) according to requested number of keys
 * 2. Import AES key and HMAC key in Key Ring A
 * 3. Create RSA & DH key in Key Ring A
 * 4. Import RSA key in Key Ring B
 * 5. Transfer AES key from Key Ring A to B
 * 6. List Ids and verify that both KR sizes are Ok
 * 7. Repeat for all keys in KR A
 * 8. Transfer the AES key from KR B to KR A
 * 9. List Ids and verify that both KR sizes are Ok
 * 
 *  * Implements KMNG ATP section 5.4 
 *
 ******************************************************************************/                                
DxError_t KMNG_ATP_TST_Operations_2_Key_Ring( void );

/*****************************************************************************
* Function Name:                                                           
*  KMNG_ATP_TST_Save_Key_Ring_To_Flash      
*  
* Inputs:
*  None
*
* Outputs: 
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
*  This function Is an acceptance test for Key management API's. The function 
*  tests the list key IDs function.
*  
* Algorithm:       
* 1. Initialize a key ring according to requested number of keys
* 2. Create Symmetric,RSA and DH keys
* 3. Get the flash needed size for saving the Key Ring
* 4. Save the key ring to "flash" (buffer)
* 5. Get Key Ring data from flash image
* 6. Restore key ring from image
* 7. Get key ring size and list Ids to verify its as expected
* 
*  * Implements KMNG ATP section 5.5 
*
******************************************************************************/                                
DxError_t KMNG_ATP_TST_Save_Key_Ring_To_Flash( void );

/*****************************************************************************
* Function Name:                                                           
*  KMNG_ATP_TST_Get_Keys_Data      
*  
* Inputs:
*  None
*
* Outputs: 
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
*  This function Is an acceptance test for Key management API's. The function 
*  initializes a key ring according to requested num of keys
*  
* Algorithm:       
* 1. Initialize Key Ring
* 2. Create RSA key and import symmetric key 
* 3. Retrieve the data from the keys and verify its correct
* 4. Update the keys user data
* 5. Retrieve the data from the keys and verify its correct
*
*  * Implements KMNG ATP section 5.6 
*
******************************************************************************/
DxError_t KMNG_ATP_TST_Get_Keys_Data( void );

#ifdef __cplusplus
}
#endif

#endif
